 
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->


<html <?php language_attributes(); ?>>



<head>
	
<title><?php

	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
	{
		echo " | $site_description";
	}

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 ) {
		echo ' | ' . sprintf( __( 'Page %s', 'THEME_FRONT_SITE' ), max( $paged, $page ) );
		}

	?></title>

    <?php
	if ( is_singular() && get_option( 'thread_comments' ) ){
		wp_enqueue_script( 'comment-reply' );
	}
	wp_head();
?>
	 
   <meta name="description" content="<?php bloginfo( 'description' ); ?>">

    <meta name="keywords" content="مرکز خرید اطلس, خوب انتخاب کنید, اطلس تبریز, مرکز خرید, Atlas Shopping Center, Tabriz Atlas, Atlas Center, Tabriz 2018" />

    <meta name="dc.publisher" content="مرکز خرید اطلس | خوب انتخاب کنید" />
    <meta name="dc.identifier" content="https://atlasshoppingcenter.ir" />
    <meta name="copyright" content="© 2018 atlas team sitename.ir)" />
    <meta name="dcterms.created" content="2018-08-20T15:24:23+00:00" />
    <meta name="dcterms.modified" scheme="ISO8601" content="2018-02-20T12:57:32" />

    <meta itemprop="name" content="مرکز خرید اطلس | خوب انتخاب کنید" />
    <meta itemprop="description" content="<?php bloginfo( 'description' ); ?>" />
    <meta itemprop="image" content="https://atlasshoppingcenter.ir/wp-content/uploads/2018/02/cropped-logo-icon-32x32.png" />



    <meta property="og:locale" content="fa_IR" />
    <meta property="og:article:author" content="atlasshoppingcenter.ir" />
    <meta property="og:article:section" content="Home" />
	<meta name="theme-color" content="#990e4c">
    <meta name="msapplication-navbutton-color" content="#990e4c">
    <meta name="apple-mobile-web-app-status-bar-style" content="#990e4c">
    <meta name="google-site-verification" content="pfH8v1ZROpHSW10umjyNFqfSy7QeFhqwu99xtrD4a8A" />    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8" />
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no, width=device-width" />
    <!-- Semantic META -->

<meta name="google-site-verification" content="pfH8v1ZROpHSW10umjyNFqfSy7QeFhqwu99xtrD4a8A" />


   

    <!--Favicon-->
    <link rel="apple-touch-icon" sizes="57x57" href="/wp-content/themes/mizbanetabatat/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/wp-content/themes/mizbanetabatat/Assets1/img/icon/favicon/favicon-16x16.png">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

		<link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_uri(); ?> " >
	    <link type="text/css" href="<?php echo get_stylesheet_uri(); ?>" rel="stylesheet" media="screen" />


	
	 


	  
    <link rel="stylesheet" href="/wp-content/themes/mizbanetabatat/assets/css/PallaFront.min.css" type="text/css">

    <link rel="stylesheet" href="/wp-content/themes/mizbanetabatat/assets/lib/sliderPro/css/slider-pro.min.css" type="text/css">
    <link rel="stylesheet" href="/wp-content/themes/mizbanetabatat/assets/lib/hyperform/css/hyperform.css" type="text/css">
    <link rel="stylesheet" href="/wp-content/themes/mizbanetabatat/assets/lib/jquery-star-rating/min/rating.css" type="text/css">
	 

    <!--Stylesheets-->
	
	

</head>
    <!-- ________________________________ :BEGIN: Main Container ________________________________ -->

<body data-direction="rtl">
    <div class="container-fluid">

<header class="main row">
    <div class="container no-gutter">
        <!--top tiny bar-->
        <div class="row-fluid top-tiny-bar">
            <div class="col-xs-12 col-md-3 languages no-gutter text-right">
                    <a class="language-item pull-left margin-right-half active" data-lang="fa" href="/">
                        <img src="/wp-content/uploads/2018/04/fa.png" alt="fa" />
                    </a>
                    <a class="language-item pull-left margin-right-half " data-lang="en" href="/en">
                        <img src="/wp-content/uploads/2018/04/En.png" alt="en" />
                    </a>
                <div class="margin-left-standard pull-right">
                        <a href="/login" class="margin-left-half"><i class="icon-m3g-login"></i> ورود به حساب کاربری</a>
                        <a href="/%d8%ab%d8%a8%d8%aa-%d9%86%d8%a7%d9%85-%d8%a8%d8%a7%d8%b4%da%af%d8%a7%d9%87-%d9%85%d8%b4%d8%aa%d8%b1%db%8c%d8%a7%d9%86/"><i class="icon-m3g-user-plus"></i> ثبت نام</a>
                </div>
            </div>
            <div class="col-xs-12 col-md-3 col-md-offset-6">
                <div class="row">
 <div class="col-xs-10 col-md-12 search-box-container tiny no-gutter">
                    <!--Search Box-->
              
<form action="<?php  echo esc_url(home_url('/')); ?>/" method="get">
                        <div class="row-fluid">

<input type="text" class="col-md-12 col-xs-12 no-gutter" name="s" id="s" placeholder="<?php echo esc_html__('نامی که به دنبال می گردید'); ?>"  />		
	
				<input  value="<?php echo esc_html__('نامی که به دنبال می گردید'); ?>" type="hidden">

                            <button type="submit" class="searchsubmit"><i class="icon-m3g-search"></i></button>
                        </div>
                    </form>

                 
                </div>
                </div>
            </div>
            <div class="clearfix"></div>
        </div>
        <!--/top tiny bar-->
        <!--main head bar-->
        <div class="row-fluid main-head-bar">
            <div class="logo-container col-xs-9 col-md-3 text-right">
                <a href="/">
                    <img class="max-full-width" src="/wp-content/themes/mizbanetabatat/assets/img/identity/logo-light.png" alt="لوگو اطلس">
                </a>
            </div>
            <div class="col-xs-3 visible-xs hidden no-gutter">
                <div class="navbar-header">
                    
                </div>
            </div>

 <div class="col-md-9 menu-wrapper no-gutter hidden-xs">

<nav class="navbar main-menu">
    <div class="container-fluid no-gutter">
   
     <div class="collapse navbar-collapse no-gutter" id="myNavbar"><ul id="menu-categories" class="nav navbar-nav navbar-right">
<?php

$header_menu = array(
    'menu_class'      => 'navbar main-menu',
    'theme_location' => 'top_menu',
    'items_wrap'      => '<ul id="%1$s" class="nav navbar-nav navbar-right">%3$s</ul>',
	 'item_spacing'      => '<li  id="%1$s"class="active">%3$s</li>',
);

wp_nav_menu( $header_menu );

?>


            </ul>
        </div>
    </div>
</nav>
            </div>
        </div>
        <!--/main head bar-->
    </div>
    <!--/Container-->

  <!-- ________________________________ :BEGIN: Mobile Menu ________________________________ -->
    <div class="m3g-overlay-menu-wrapper hidden-sm visible-xs">
        <button type="button" class="navbar-toggle m3g-menu-toggler" data-toggle="collapse" data-target="#myNavbar">
            <i class="icon icon-m3g-menu open-menu"></i>
            <i class="icon icon-m3g-cross2 close-menu"></i>
        </button>
        <div class="inner row">
            <div class="col-xs-12">
			<nav class="navbar main-menu">

                <div class="row text-center"><img src="/wp-content/themes/mizbanetabatat//assets/img/identity/logo-light.png" alt=""></div>
                <div class="row menu-container">
                    <ul class="plain-ul">
                <?php

$header_menu = array(
    'menu_class'      => 'navbar main-menu',
    'theme_location' => 'top_menu',
    'items_wrap'      => '<ul id="%1$s" class="nav navbar-nav navbar-right">%3$s</ul>',
	 'item_spacing'      => '<li  id="%1$s"class="active">%3$s</li>',
);

wp_nav_menu( $header_menu );

?>
                    </ul>
                </div>
				</nav>
            </div>
        </div>
    </div>
    <!-- ________________________________ :END: Mobile Menu ________________________________ -->

    </div>
</header>




